﻿/**
 * Создаёт размерные линии: высоту, ширину, центр, радиус, диаметр выделенного объекта
 *
 * @param {Object} u ползовательские параметры полей ввода интерфейса
 * @return {GroupItem} meas группа разметки (размер, стрелки, линии)
 */
//@target illustrator

function measAllSelect ( u ) {
  if ( !selection[ 0 ] ) {
    return /*new Error ( 'Make selection!' )*/;
  }
  var res = [];

  if ( selection.length == 2 && u.ctrl == true ) {
    if ( (selection[ 0 ].name).match ( /\d{7}/ ) || (selection[ 1 ].name).match ( /\d{7}/ ) ) return;
    res[ 0 ] = measure ( u, -1 );
    return JSON.stringify ( res );
  }

  for ( var i = 0; i < selection.length; i++ ) {
// is this a try do not make dimensions to the dimensions itself??
    if ( (selection[ i ].name).match ( /\d{7}/ ) ) continue;
    res[ i ] = (measure ( u, i ));
  }

  return JSON.stringify ( res );
}

function measure ( u, iterator ) {

  //  if ( !u.side ) return;

  var PT_TO_MM = 2.834645668,
      MM_TO_PT = 0.352777778;

  // input by user from panel
  var side            = u.side,
      modCtrl         = u.ctrl,
      strkW           = u.strkW,
      colorComponents = u.colComp,
      units           = ' ' + u.units,
      arW             = u.arW,
      gap             = u.gap,
      stopBot         = u.stopBot,
      stopTop         = u.stopTop + 1,
      fontSize        = u.fontSize,
      precis          = u.precis, // precition - n digits after comma
      fontNum         = u.fontNum,
      measType        = u.measType,
      addLay          = u.addLay,
      layName         = u.layName;

  // the data from active document or calculating based on data from UI
  var arH      = arW / 1.9,
      col      = setCmyk ( colorComponents ),
      fontName = getFontsAvailable ()[ fontNum ],
      bounds,
      left,
      right,
      top,
      bott,
      elW,
      elH;

  if ( ~iterator ) { // play when tierator != -1
    bounds = getBounds ( selection[ iterator ], [] );
    left = bounds[ 0 ];
    right = bounds[ 2 ];
    top = bounds[ 1 ];
    bott = bounds[ 3 ];
    elW = bounds[ 2 ] - bounds[ 0 ];
    elH = bounds[ 1 ] - bounds[ 3 ];
  } else if ( !~iterator && measType == 'linear' ) {
    var rect; // area-rectangle between the selected items
    switch ( side ) {
      case 'top':
      case 'bott':
        rect = getRectByHorizGap ( selection );
        break;
      case 'left':
      case 'right':
        rect = getRectByVertGap ( selection );
        break;
      default:
        break;
    }

    left = rect[ 0 ];
    top = rect[ 1 ];
    right = rect[ 2 ];
    bott = rect[ 3 ];
    elW = rect[ 2 ] - rect[ 0 ];
    elH = rect[ 1 ] - rect[ 3 ];
  }

  var lablW = (Math.round ( elW / (PT_TO_MM * Math.pow ( 10, -precis )) )) / Math.pow ( 10, precis ),//!ПУСТЫЕ НУЛИ
      lablH = (Math.round ( elH / (PT_TO_MM * Math.pow ( 10, -precis )) )) / Math.pow ( 10, precis ),//!ОТБРАСЫВАЮТСЯ
      lablR = (Math.round ( (elW / 2) / (PT_TO_MM * Math.pow ( 10, -precis )) )) / Math.pow ( 10, precis );

  var lay, meas, txt,
      arPoints, linePoints, stopPoints, labelCont, lineL, lineR, stopL, stopR, arL, arR;

  if ( rect == false ) return;

  try {
    lay = activeDocument.layers.getByName ( layName );
    if ( lay.visible == false || lay.locked == true ) {
      if ( addLay ) {
        lay = activeDocument.layers.add ();
        lay.name = layName;
      } else {
        iterator != -1 ? lay = selection[ iterator ].layer : lay = activeDocument.activeLayer;
      }
    }
    meas = lay.groupItems.add ();
    if ( measType != 'diam' && measType != 'rad' ) {
      txt = meas.textFrames.add ();
    }
  } catch ( e ) {
    if ( addLay ) {
      lay = activeDocument.layers.add ();
      lay.name = layName;
    } else {
      iterator != -1 ? lay = selection[ iterator ].layer : lay = activeDocument.activeLayer;
    }

    meas = lay.groupItems.add ();
    if ( measType != 'cent' && measType != 'diam' && measType != 'rad' ) {
      txt = meas.textFrames.add ();
    }
  }

  meas.name = makeRandStr ( 7 );

  switch ( measType ) {
    case 'linear':
      addLinear ();
      break;
    case 'rad':
      addRad ();
      break;
    case 'diam':
      addDiam ();
      break;
    case 'cent':
      addCent ();
      break;
    default:
      break;
  }

  function addRad () {

    txt = meas.textFrames.add ();
    labelCont = lablW + ' x ' + lablH + units
    txt.contents = labelCont;
    txt = _addLabel ();
    txt.rotate ( 90 );
    
    txt.position = [ right + stopBot, top ];

    return meas;
  }

  function addDiam () {
   
    txt = meas.textFrames.add ();
    labelCont = lablW + ' x ' + lablH + units
    txt.contents = labelCont;
    txt = _addLabel ();
    txt.position = [ left , bott - stopBot ];

    return meas;
  }

 

  function addLinear () {
    switch ( side ) {
      case 'top':
//        meas.name = 'tp' + meas.name;
        labelCont = lablW + units;
        txt = _addLabel ();
        meas = _addBaseMeas ( elW );
        if ( txt.width < (elW - gap * 2 - arW * 3) ) {
          meas.position = [ left, top + stopTop ];
        } else {
          meas.position = [ left - arW * 2, top + stopTop ];
        }
        break;
      case 'bott':
//        meas.name = 'bm' + meas.name;
        labelCont = lablW + units;
        txt = _addLabel ();
        meas = _addBaseMeas ( elW );
        meas.rotate ( 180 );
        meas.textFrames[ 0 ].rotate ( 180 );

        if ( txt.width < (elW - gap * 2 - arW * 3) ) {
          meas.position = [ left, bott - stopBot ];
        } else {
          if ( txt.width > elW - arW ) {
            meas.textFrames[ 0 ].translate ( elW + txt.width + arW * 4 + gap * 2 );
          }
          meas.position = [ left - arW * 2, bott - stopBot ];
        }
        break;
      case 'left':
//        meas.name = 'lf' + meas.name;
        labelCont = lablH + units;
        txt = _addLabel ();
        meas = _addBaseMeas ( elH );
        meas.rotate ( 90 );
        if ( txt.height < (elH - gap * 2 - arW * 3) ) {
          meas.position = [ left - meas.width - stopBot, top ];
        } else {
          if ( txt.height > elH - arW ) {
            meas.position = [ left - meas.width - stopBot, top + txt.height + arW * 2 + gap ];
          } else {
            meas.position = [ left - meas.width - stopBot, top + arW * 2 ];
          }
        }
        break;
      case 'right':
//        meas.name = 'rt' + meas.name;
        labelCont = lablH + units;
        txt = _addLabel ();
        meas = _addBaseMeas ( elH );
        meas.rotate ( -90 );
        meas.textFrames[ 0 ].rotate ( 180 );

        if ( txt.height < (elH - gap * 2 - arW * 3) ) {
          meas.position = [ right + stopBot, top ];
        } else {
          meas.position = [ right + stopBot, top + arW * 2 ];
          if ( txt.height > elH - arW ) {
            meas.textFrames[ 0 ].translate ( 0, txt.height + elH + arW * 4 + gap * 2 );
          }
        }

        break;
      default:
        break;
    }

    function _addBaseMeas ( sideLength ) {

      if ( txt.width < (sideLength - gap * 2 - arW * 3) ) {
        txt.position = [ sideLength / 2 - txt.width / 2, stopTop ];

        linePoints = [
          [ 0, stopTop - txt.height / 2 ],
          [ sideLength / 2 - txt.width / 2 - gap / 2, stopTop - txt.height / 2 ]
        ];
        lineL = _addLine ( linePoints );
        lineR = lineL.duplicate ();
        lineR.translate ( lineL.width + txt.width + gap );

        stopPoints = [ [ 0, stopBot ], [ 0, stopTop ] ];
        stopL = _addLine ( stopPoints );
        stopR = stopL.duplicate ();
        stopR.translate ( sideLength );

        arPoints = [ [ arW, stopTop - txt.height / 2 - arH / 2 ],
                     [ 0, stopTop - txt.height / 2 ],
                     [ arW, stopTop - txt.height / 2 + arH / 2 ] ];
        arL = _addArrow ( arPoints );
        arR = arL.duplicate ();
        arR.rotate ( 180 );
        arR.translate ( sideLength - arW );

      } else if ( txt.width > (sideLength - gap * 2 - arW * 3) ) {

        if ( txt.width < sideLength - arW ) {
          txt.position = [ sideLength / 2 - txt.width / 2, stopTop ];
        } else {
          txt.position = [ sideLength + arW * 2 + gap, stopTop ];
        }
        linePoints = [ [ 0, stopTop - txt.height / 2 ],
                       [ -arW * 2, stopTop - txt.height / 2 ] ];
        lineL = _addLine ( linePoints );
        lineR = lineL.duplicate ();
        lineR.translate ( lineL.width + sideLength );

        stopPoints = [ [ 0, stopBot ], [ 0, stopTop ] ];
        stopL = _addLine ( stopPoints );
        stopR = stopL.duplicate ();
        stopR.translate ( sideLength );

        arPoints = [ [ arW, stopTop - txt.height / 2 - arH / 2 ],
                     [ 0, stopTop - txt.height / 2 ],
                     [ arW, stopTop - txt.height / 2 + arH / 2 ] ];
        arL = _addArrow ( arPoints );
        arR = arL.duplicate ();
        arR.translate ( sideLength );
        arL.rotate ( 180, true, true, true, true, Transformation.LEFT );
      }

      return meas;
    }
  }

  /**
   * @return {TextFrameItem} txt
   * */
  function _addLabel () {
    var labl = txt;

    labl.contents = labelCont;

    labl.paragraphs[ 0 ].paragraphAttributes.justification = Justification.CENTER;

    if ( col ) {
      labl.textRange.characterAttributes.fillColor = col;
      labl.textRange.characterAttributes.textFont = textFonts.getByName ( fontName );
    }
    labl.textRange.characterAttributes.size = fontSize;

    return labl;
  }

  function _addLine ( points ) {
    var line = meas.pathItems.add ();

    line.setEntirePath ( points );
    line.stroked = true;
    line.strokeWidth = strkW;
    line.strokeCap = StrokeCap.BUTTENDCAP;
    line.strokeDashes = [];

    line.filled = false;

    if ( col ) {
      line.strokeColor = col;
    }

    return line;
  }

  function _addArrow ( points ) {
    var arrow = meas.pathItems.add ();

    arrow.setEntirePath ( points );
    arrow.stroked = true;
    arrow.strokeWidth = strkW;
    arrow.strokeJoin = StrokeJoin.ROUNDENDJOIN;
    arrow.strokeDashes = [];

    arrow.closed = true;

    if ( col ) {
      arrow.strokeColor = col;
      arrow.fillColor = col;
    }
    return arrow;
  }

  /**
   *  COMMON LIB **********************
   * */

  function getRectByVertGap ( sel ) {

    var tp_bnds = getBounds ( sel[ 0 ], [] ),
        bt_bnds = getBounds ( sel[ 1 ], [] );

    var left, top, right, bottom;

    if ( tp_bnds[ 3 ] > bt_bnds[ 1 ] ) {
      // top item is top, there is a gap between items on the Y-axis
      top = tp_bnds[ 3 ];
      bottom = bt_bnds[ 1 ];
    } else if ( bt_bnds[ 3 ] > tp_bnds[ 1 ] ) {
      // bottom item is top, there is a gap between items on the Y-axis
      top = bt_bnds[ 3 ];
      bottom = tp_bnds[ 1 ];
    } else {
      // there is not gap between items along Y-exis
      return false;
    }

    tp_bnds[ 0 ] <= bt_bnds[ 0 ] ? left = tp_bnds[ 0 ] : left = bt_bnds[ 0 ];
    tp_bnds[ 2 ] >= bt_bnds[ 2 ] ? right = tp_bnds[ 2 ] : right = bt_bnds[ 2 ];

    return [ left, top, right, bottom ];
  }

  function getRectByHorizGap ( sel ) {

    var tp_bnds = getBounds ( sel[ 0 ], [] ),
        bt_bnds = getBounds ( sel[ 1 ], [] );

    var left, top, right, bottom;

    if ( tp_bnds[ 2 ] < bt_bnds[ 0 ] ) {
      // top item is left, there is a gap between items on the X-axis
      left = tp_bnds[ 2 ];
      right = bt_bnds[ 0 ];
    } else if ( bt_bnds[ 2 ] < tp_bnds[ 0 ] ) {
      // bottom item is left, there is a gap between items on the X-axis
      left = bt_bnds[ 2 ];
      right = tp_bnds[ 0 ];
    } else {
      // there is not gap between items along X-exis
      return false;
    }

    tp_bnds[ 1 ] >= bt_bnds[ 1 ] ? top = tp_bnds[ 1 ] : top = bt_bnds[ 1 ];
    tp_bnds[ 3 ] <= bt_bnds[ 3 ] ? bottom = tp_bnds[ 3 ] : bottom = bt_bnds[ 3 ];

    return [ left, top, right, bottom ];
  }

  /**
   * checking on circle
   *
   * @param {PathItem} elem the object of class PathItem
   * @return {Boolean} true/false
   */


  function setCmyk ( comp ) {
    var col = new CMYKColor ();
    col.cyan = comp[ 0 ];
    col.magenta = comp[ 1 ];
    col.yellow = comp[ 2 ];
    col.black = comp[ 3 ];
    return col;
  }

// сравнить и вернуть самые широкие (с учётом масок) geometricBounds коллекции элементов
  function getBounds ( selElem, bounds ) {
    var clipGroupElems, i, j;

    if ( selElem.typename != 'GroupItem' ) { // любой отдельный элемент неконтейнер
      return selElem.geometricBounds;
    }
    if ( selElem.clipped ) { // группа с маской => ищем маску
      clipGroupElems = selElem.pathItems;

      for ( i = 0; i < clipGroupElems.length; i++ ) {
        if ( clipGroupElems[ i ].clipping ) {
          if ( bounds == '' ) {
            bounds = clipGroupElems[ i ].geometricBounds;
            continue;
          }
          bounds = _compareBounds ( clipGroupElems[ i ], bounds );
        }
      }
      return bounds;
    }

    // группа без обтравочной маски => цикл по элементам группы
    for ( j = 0; j < selElem.pageItems.length; j++ ) {

      var el = selElem.pageItems [ j ];

      if ( el.typename != 'GroupItem' ) { // любой pageItem кроме группы
        if ( bounds == '' ) {
          bounds = el.geometricBounds;
          continue;
        }
        bounds = _compareBounds ( el, bounds );
      }

      if ( el.typename == 'GroupItem' && el.clipped ) { // группа с маской => ищем маску
        clipGroupElems = el.pathItems;
        for ( i = 0; i < clipGroupElems.length; i++ ) {
          if ( clipGroupElems[ i ].clipping ) {
            if ( bounds == '' ) {
              bounds = clipGroupElems[ i ].geometricBounds;
              continue;
            }
            bounds = _compareBounds ( clipGroupElems[ i ], bounds );
          }
        }
        continue;
      }

      if ( el.typename == 'GroupItem' && !el.groupItems && !el.clipped ) { // группа без маски и без групп
        if ( bounds == '' ) {
          bounds = el.geometricBounds;
//          bounds = getBounds ( el.pageItems, bounds );
          continue;
        }
        bounds = _compareBounds ( el.geometricBounds, bounds );
        continue;
      }

      if ( el.typename == 'GroupItem' && el.groupItems ) { // группа без маски, но с группами => рекурсия
        for ( var l = 0; l < el.pageItems.length; l++ ) {
          /* if ( bounds == '' ) {
           bounds = getBounds ( el.pageItems[l], '' );
           }*/
          bounds = getBounds ( el.pageItems[ l ], bounds );
        }
        continue;
      }
    }
    return bounds;

    // сравнить и вернуть самые широкие geometricBounds элемента
    function _compareBounds ( elem, boundsToCompare ) {
      var elemBounds = elem.geometricBounds;
      elemBounds[ 0 ] < boundsToCompare[ 0 ] ? boundsToCompare[ 0 ] = elemBounds[ 0 ] : '';
      elemBounds[ 1 ] > boundsToCompare[ 1 ] ? boundsToCompare[ 1 ] = elemBounds[ 1 ] : '';
      elemBounds[ 2 ] > boundsToCompare[ 2 ] ? boundsToCompare[ 2 ] = elemBounds[ 2 ] : '';
      elemBounds[ 3 ] < boundsToCompare[ 3 ] ? boundsToCompare[ 3 ] = elemBounds[ 3 ] : '';
      return boundsToCompare;
    }

  }

  /**
   * Фильтрует имена неустановленных в системе шрифтов
   *
   * @param {Array} arr опциональный массив имён шрифтов
   * @return {Array} fonts отфильтрованный массив имён шрифтов
   */
  function getFontsAvailable ( arr ) {
    var fonts          = [],
        fontNamesArray = arr || [
            'MyriadPro-BoldCond', 'MyriadPro-Black', 'MyriadPro-Bold', 'MyriadPro-Regular',
            'MyriadPro-Cond', 'Monaco-Bold',
            'Arial-Bold', 'Arial-BoldMT', 'Arial-Black',
            'ComicSansMS-Bold', 'Calibri-Bold', 'CourierNewPS-BoldMT', 'Courier-Bold',
            'Charcoal',
            'DejaVuSans-Bold',
            'Geneva-Bold', 'Impact',
            'Nimbus-Sans-Bold', 'NimbusMonoL-Bold',
            'TrebuchetMS-Bold', 'Tahoma-Bold',
            'Verdana-Bold'
          ]

// записать шрифты с поддержкой всех символов логических операций в массив
    for ( var i = 0; i < fontNamesArray.length; i++ ) {
      try {
        fonts.push ( (textFonts.getByName ( fontNamesArray[ i ] ).name) );
      } catch ( e ) {
      }
    }
    return fonts;
  }

  /**
   * Вычисление реальной высоты символа F, нижнего и верхнего отступов
   *
   * @param {TextFrameItem} frame текстовый фрейм
   * @return {Object} val три вычисленных парамтра chr, top, bot + toString() для их просмотра
   */
  function calcFontDims ( frame ) {
    var F   = activeDocument.activeLayer.textFrames.add (),
        fullH,
        val = {
          h:        0,
          top:      0,
          bot:      0,
          toString: function () {
            return 'Реальная высота символа: ' + this.h + '\n;' +
              'Верхний отступ: ' + this.top + '\n;' +
              'Нижний отступ: ' + this.bot + '.';
          }
        };

    F.contents = 'F';
    F.textRange.characterAttributes.textFont = frame.textRange.characterAttributes.textFont;
    F.textRange.characterAttributes.size = frame.textRange.characterAttributes.size;

    var F_curv = (F.duplicate ()).createOutline ();

    fullH   = F.height;
    val.h   = F_curv.height;
    val.top = Math.abs ( F.position[ 1 ] - F_curv.position[ 1 ] );
    val.bot = (fullH - val.h - val.top);

    F.remove ();
    F_curv.remove ();

    return val;
  }

  function makeRandStr ( len ) {
    return ('1' + (new Date ()) * Math.random () * 10000).slice ( 0, len );
  }

  return meas.name;
}

function delMeasByName ( name, i ) {
  try {
    var el = activeDocument.groupItems.getByName ( name );
    if ( selection[ 0 ] ) {
      el.remove ();
      return true;
    }
  } catch ( e ) {
    return false;
  }
}

function getAiVers () {
  return (app.version).slice( 0, 2 );
  //return JSON.stringify (res);
}
